/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.measures;

import java.util.UUID;
import mod.chiselsandbits.api.measuring.IMeasurement;
import mod.chiselsandbits.api.measuring.MeasuringMode;
import mod.chiselsandbits.api.util.IPacketBufferSerializable;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class Measurement
implements IMeasurement,
IPacketBufferSerializable {
    private UUID owner;
    private class_243 from;
    private class_243 to;
    private MeasuringMode mode;
    private class_2960 worldKey;

    public Measurement(UUID owner, class_243 from, class_243 to, class_2350 hitFace, MeasuringMode mode, class_2960 worldKey) {
        this.owner = owner;
        this.mode = mode;
        this.worldKey = worldKey;
        this.adaptPositions(from, to, hitFace, mode);
    }

    public Measurement() {
    }

    private void adaptPositions(class_243 from, class_243 to, class_2350 hitFace, MeasuringMode mode) {
        this.from = mode.getType().isNeedsNormalization() ? new class_243(Math.min(from.method_10216(), to.method_10216()), Math.min(from.method_10214(), to.method_10214()), Math.min(from.method_10215(), to.method_10215())) : from;
        this.to = mode.getType().isNeedsNormalization() ? new class_243(Math.max(from.method_10216(), to.method_10216()), Math.max(from.method_10214(), to.method_10214()), Math.max(from.method_10215(), to.method_10215())) : to;
        this.from = mode.getType().adaptStartCorner(this.from, this.to, hitFace);
        this.to = mode.getType().adaptEndCorner(this.from, this.to, hitFace);
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public class_243 getFrom() {
        return this.from;
    }

    @Override
    public class_243 getTo() {
        return this.to;
    }

    @Override
    public MeasuringMode getMode() {
        return this.mode;
    }

    @Override
    public class_2960 getWorldKey() {
        return this.worldKey;
    }

    @Override
    public void serializeInto(@NotNull class_2540 packetBuffer) {
        packetBuffer.method_10797(this.getOwner());
        packetBuffer.writeDouble(this.getFrom().method_10216());
        packetBuffer.writeDouble(this.getFrom().method_10214());
        packetBuffer.writeDouble(this.getFrom().method_10215());
        packetBuffer.writeDouble(this.getTo().method_10216());
        packetBuffer.writeDouble(this.getTo().method_10214());
        packetBuffer.writeDouble(this.getTo().method_10215());
        packetBuffer.method_10804(this.mode.ordinal());
        packetBuffer.method_10788(this.getWorldKey().toString(), 0x1FFFFFFF);
    }

    @Override
    public void deserializeFrom(@NotNull class_2540 packetBuffer) {
        this.owner = packetBuffer.method_10790();
        this.from = new class_243(packetBuffer.readDouble(), packetBuffer.readDouble(), packetBuffer.readDouble());
        this.to = new class_243(packetBuffer.readDouble(), packetBuffer.readDouble(), packetBuffer.readDouble());
        this.mode = MeasuringMode.values()[packetBuffer.method_10816()];
        this.worldKey = new class_2960(packetBuffer.method_10800(0x1FFFFFFF));
    }
}

